/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DesktopStarter
extends JFrame {
    private double windowWidth;
    private double windowHeight;
    private double winXmin;
    private double winYmin;
    private double winYMax;
    private Spaceobject spaceship;
    private Spaceobject planet;
    private Spaceobject comet;
    private Stack<Spaceobject> spaceobjectStack = new Stack();
    private JComponent mainComponent;
    private JPanel infoPanel;
    private JLabel distanceToHomeLabel;
    private JLabel distanceToCometLabel;
    private JLabel scaleLabel;
    private JLabel spaceLocationLabel;
    private JLabel screenLocationLabel;
    private JLabel angleToHomeLabel;
    private JLabel angleToCometLabel;
    private JLabel directionToHomeLabel;
    private JLabel directionToCometLabel;
    private JLabel speedLabel;
    private JLabel windowLabel;
    private JLabel testLabel;
    private JLabel testLabel2;
    private BufferedImage arrowImage;
    private BufferedImage backgroundImage;
    private ImageIcon arrowIcon;
    private Point2D focus = new Point2D.Double(0.0, 0.0);
    private Point2D cometInitialLocation;
    private LAVector cometInitialImpuls = new LAVector(2.0, Math.toRadians(90.0));
    private double scaleFactor = 1.0;
    private double maxScaleFactor = 0.8;
    private double minScaleFactor = 0.3;
    private double distanceToFocus;
    private double angleToFocus;
    private double elipseLine;
    private static final DecimalFormat twoDigits = new DecimalFormat("#.##");
    private static final DecimalFormat zeroDigits = new DecimalFormat("#");
    private boolean leftKeyPressed = false;
    private boolean rightKeyPressed = false;
    private boolean upKeyPressed = false;
    private boolean downKeyPressed = false;
    private boolean leftShiftPressed;
    private boolean spacePressed;
    private boolean mPressed;
    private boolean yPressed = false;

    public DesktopStarter() {
        this.setSize(1000, 600);
        this.setLocation(320, 20);
        this.setDefaultCloseOperation(3);
        this.spaceship = new Spaceobject((Point2D)new Point2D.Double(200.0, 300.0), 1.0);
        this.spaceship.addImage("/Ressources/spaceship04I.png");
        this.spaceship.addImage("/Ressources/spaceship04.png");
        this.spaceship.setAngle(Math.toRadians(0.0));
        this.spaceship.setMass(4000.0);
        this.planet = new Spaceobject((Point2D)new Point2D.Double(100.0, 100.0), 0.9);
        this.planet.addImage("/Ressources/planet00.png");
        this.planet.setMass(2000.0);
        this.spaceobjectStack.add(this.planet);
        this.spaceobjectStack.add(this.spaceship);
        this.cometInitialLocation = new Point2D.Double(600.0, 0.0);
        this.comet = new Spaceobject(this.cometInitialLocation, this.cometInitialImpuls);
        this.comet.addImage("/Ressources/comet00.png");
        this.comet.scaleImage(0.5, 0.5);
        this.comet.setMass(2.0);
        this.spaceobjectStack.add(this.comet);
        this.focus = this.planet.getSpaceLocation();
        try {
            this.backgroundImage = ImageIO.read(this.getClass().getResource("/Ressources/background021.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Font labelFont = new Font("Arial", 1, 16);
        try {
            this.arrowImage = ImageIO.read(this.getClass().getResource("/Ressources/arrowOrange.png"));
            this.arrowIcon = new ImageIcon(this.arrowImage.getScaledInstance(100, 150, 4));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.distanceToHomeLabel = new JLabel("distanceToHomeLabel");
        this.distanceToHomeLabel.setFont(labelFont);
        this.distanceToCometLabel = new JLabel("distanceToCometLabel");
        this.distanceToCometLabel.setFont(labelFont);
        this.scaleLabel = new JLabel("scaleLabel");
        this.scaleLabel.setFont(labelFont);
        this.spaceLocationLabel = new JLabel("spaceLocationLabel");
        this.spaceLocationLabel.setFont(labelFont);
        this.screenLocationLabel = new JLabel("screenLocationLabel");
        this.screenLocationLabel.setFont(labelFont);
        this.angleToHomeLabel = new JLabel("angleToHomeLabel");
        this.angleToHomeLabel.setFont(labelFont);
        this.angleToCometLabel = new JLabel("angleToCometLabel");
        this.angleToCometLabel.setFont(labelFont);
        this.speedLabel = new JLabel("speedLabel");
        this.speedLabel.setFont(labelFont);
        this.directionToHomeLabel = new JLabel(this.arrowIcon){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setBackground(this.getBackground());
                g2.clearRect(0, 0, DesktopStarter.this.arrowIcon.getIconWidth(), DesktopStarter.this.arrowIcon.getIconHeight());
                AffineTransform oldTransform = g2.getTransform();
                AffineTransform newTransform = (AffineTransform)oldTransform.clone();
                LAVector LAVector2 = new LAVector(DesktopStarter.this.spaceship.getSpaceLocation(), DesktopStarter.this.planet.getSpaceLocation());
                newTransform.rotate(LAVector2.getAngle() + 1.5707963267948966, DesktopStarter.this.arrowIcon.getIconWidth() / 2, DesktopStarter.this.arrowIcon.getIconHeight() / 2);
                g2.setTransform(newTransform);
                DesktopStarter.this.arrowIcon.paintIcon(this, g2, 0, 0);
                g2.setTransform(oldTransform);
            }
        };
        this.directionToCometLabel = new JLabel(this.arrowIcon){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setBackground(this.getBackground());
                g2.clearRect(0, 0, DesktopStarter.this.arrowIcon.getIconWidth(), DesktopStarter.this.arrowIcon.getIconHeight());
                AffineTransform oldTransform = g2.getTransform();
                AffineTransform newTransform = (AffineTransform)oldTransform.clone();
                LAVector LAVector2 = new LAVector(DesktopStarter.this.spaceship.getSpaceLocation(), DesktopStarter.this.comet.getSpaceLocation());
                newTransform.rotate(LAVector2.getAngle() + 1.5707963267948966, DesktopStarter.this.arrowIcon.getIconWidth() / 2, DesktopStarter.this.arrowIcon.getIconHeight() / 2);
                g2.setTransform(newTransform);
                DesktopStarter.this.arrowIcon.paintIcon(this, g2, 0, 0);
                g2.setTransform(oldTransform);
            }
        };
        this.windowLabel = new JLabel("windowLabel");
        this.windowLabel.setFont(labelFont);
        this.testLabel = new JLabel("da sys\u00b4 work fain");
        this.testLabel.setFont(labelFont);
        this.testLabel2 = new JLabel("all da sys\u00b4. rea\u00b4y");
        this.testLabel2.setFont(labelFont);
        int strutAmount = 2;
        this.infoPanel = new JPanel();
        this.infoPanel.setPreferredSize(new Dimension(this.getWidth() / 5, this.getHeight()));
        this.infoPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.infoPanel.add(Box.createVerticalStrut(strutAmount));
        this.infoPanel.add(this.distanceToHomeLabel);
        this.infoPanel.add(Box.createVerticalStrut(strutAmount));
        this.infoPanel.add(this.directionToHomeLabel);
        this.infoPanel.add(Box.createVerticalStrut(strutAmount));
        this.infoPanel.add(this.speedLabel);
        this.infoPanel.add(Box.createVerticalStrut(strutAmount));
        this.infoPanel.add(this.distanceToCometLabel);
        this.infoPanel.add(Box.createVerticalStrut(strutAmount));
        this.infoPanel.add(this.directionToCometLabel);
        this.infoPanel.add(Box.createVerticalStrut(strutAmount));
        this.infoPanel.add(this.testLabel);
        this.infoPanel.add(Box.createVerticalStrut(strutAmount));
        this.infoPanel.add(this.testLabel2);
        JPanel leftMarginPanel = new JPanel();
        leftMarginPanel.setOpaque(false);
        leftMarginPanel.setPreferredSize(new Dimension(10, 1));
        this.infoPanel.add(leftMarginPanel);
        this.mainComponent = new JComponent(){
            int backgroundScrollX = 0;
            int backgroundScrollY = 0;

            @Override
            protected void paintComponent(Graphics g) {
                double bgHeightAdjustment;
                double bgWidthAdjustment;
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                DesktopStarter.this.scale();
                DesktopStarter.this.window();
                AffineTransform oldTransform = g2.getTransform();
                AffineTransform newTransform = (AffineTransform)oldTransform.clone();
                double backgroundConvenienceFactor = 0.8;
                double backgroundScaleFactor = DesktopStarter.this.scaleFactor * backgroundConvenienceFactor + DesktopStarter.this.minScaleFactor - backgroundConvenienceFactor * DesktopStarter.this.minScaleFactor;
                double magnification = 4.0;
                if ((double)DesktopStarter.this.backgroundImage.getWidth() < (double)DesktopStarter.this.mainComponent.getWidth() * magnification || (double)DesktopStarter.this.backgroundImage.getHeight() < (double)DesktopStarter.this.mainComponent.getHeight() * magnification) {
                    bgWidthAdjustment = this.getSize().getWidth() * (1.0 / DesktopStarter.this.minScaleFactor) * magnification / (double)DesktopStarter.this.backgroundImage.getWidth();
                    bgHeightAdjustment = this.getSize().getHeight() * (1.0 / DesktopStarter.this.minScaleFactor) * magnification / (double)DesktopStarter.this.backgroundImage.getHeight();
                } else {
                    bgWidthAdjustment = 1.0;
                    bgHeightAdjustment = 1.0;
                }
                newTransform.translate(this.getWidth() / 2, this.getHeight() / 2);
                newTransform.scale(bgWidthAdjustment, bgHeightAdjustment);
                newTransform.scale(backgroundScaleFactor, backgroundScaleFactor);
                this.backgroundScrollX = (int)DesktopStarter.this.spaceship.getSpaceLocation().getX();
                this.backgroundScrollY = (int)DesktopStarter.this.spaceship.getSpaceLocation().getY();
                while (this.backgroundScrollX <= -DesktopStarter.this.backgroundImage.getWidth() / 2) {
                    this.backgroundScrollX += DesktopStarter.this.backgroundImage.getWidth();
                }
                while (this.backgroundScrollX > DesktopStarter.this.backgroundImage.getWidth() / 2) {
                    this.backgroundScrollX -= DesktopStarter.this.backgroundImage.getWidth();
                }
                while (this.backgroundScrollY <= -DesktopStarter.this.backgroundImage.getHeight() / 2) {
                    this.backgroundScrollY += DesktopStarter.this.backgroundImage.getHeight();
                }
                while (this.backgroundScrollY > DesktopStarter.this.backgroundImage.getHeight() / 2) {
                    this.backgroundScrollY -= DesktopStarter.this.backgroundImage.getHeight();
                }
                g2.setTransform(newTransform);
                g2.drawImage((Image)DesktopStarter.this.backgroundImage, -this.backgroundScrollX, -this.backgroundScrollY, this);
                newTransform.scale(-1.0, 1.0);
                g2.setTransform(newTransform);
                g2.drawImage((Image)DesktopStarter.this.backgroundImage, this.backgroundScrollX, -this.backgroundScrollY, this);
                newTransform.scale(1.0, -1.0);
                g2.setTransform(newTransform);
                g2.drawImage((Image)DesktopStarter.this.backgroundImage, this.backgroundScrollX, this.backgroundScrollY, this);
                newTransform.scale(-1.0, 1.0);
                g2.setTransform(newTransform);
                g2.drawImage((Image)DesktopStarter.this.backgroundImage, -this.backgroundScrollX, this.backgroundScrollY, this);
                g2.setTransform(oldTransform);
                int i = 0;
                while (i < DesktopStarter.this.spaceobjectStack.size()) {
                    Spaceobject spaceobject = (Spaceobject)DesktopStarter.this.spaceobjectStack.elementAt(i);
                    BufferedImage objectImage = spaceobject.getImage();
                    Point screenLocation = DesktopStarter.this.calculateScreenLocation(spaceobject);
                    newTransform = (AffineTransform)oldTransform.clone();
                    newTransform.scale(DesktopStarter.this.scaleFactor * spaceobject.getConvenientScaleFactor(), DesktopStarter.this.scaleFactor * spaceobject.getConvenientScaleFactor());
                    if (spaceobject.rotates) {
                        newTransform.rotate(spaceobject.getAngle(), screenLocation.getX() / DesktopStarter.this.scaleFactor, screenLocation.getY() / DesktopStarter.this.scaleFactor);
                    }
                    newTransform.translate(screenLocation.getX() / DesktopStarter.this.scaleFactor / spaceobject.getConvenientScaleFactor() - (double)(objectImage.getWidth() / 2), screenLocation.getY() / DesktopStarter.this.scaleFactor / spaceobject.getConvenientScaleFactor() - (double)(objectImage.getHeight() / 2));
                    g2.setTransform(newTransform);
                    g2.drawImage((Image)objectImage, 0, 0, null);
                    if (spaceobject.showsOutline()) {
                        g2.setColor(spaceobject.outlineColor);
                        g2.setStroke(new BasicStroke(5.0f));
                        g2.draw(DesktopStarter.this.spaceship.getObjectArea());
                    }
                    g2.setTransform(oldTransform);
                    if (spaceobject.activateBeam()) {
                        g2.setColor(spaceobject.beamColor);
                        g2.setStroke(new BasicStroke((int)(10000.0 / DesktopStarter.this.spaceship.getSpaceLocation().distance(DesktopStarter.this.comet.getSpaceLocation()))));
                        g2.drawLine((int)screenLocation.getX(), (int)screenLocation.getY(), (int)DesktopStarter.this.calculateScreenLocation(DesktopStarter.this.comet).getX(), (int)DesktopStarter.this.calculateScreenLocation(DesktopStarter.this.comet).getY());
                    }
                    ++i;
                }
            }
        };
        this.mainComponent.setSize(this.getWidth() * 4 / 5, this.getHeight());
        this.getContentPane().add((Component)this.mainComponent, "Center");
        this.getContentPane().add((Component)this.infoPanel, "West");
        this.setUpKeyBindings();
    }

    public void updateMonitorWindow() {
        SwingUtilities.invokeLater(() -> {
            this.distanceToHomeLabel.setText("<html>Heimat Entfernung:<br> " + twoDigits.format(this.spaceship.getDistanceTo(this.focus)) + "</html>");
            this.distanceToCometLabel.setText("<html>Entfernung vom Meteor:<br> " + twoDigits.format(this.spaceship.getDistanceTo(this.comet.getSpaceLocation())) + " </html>");
            this.scaleLabel.setText("ScaleFactor: " + this.scaleFactor);
            this.spaceLocationLabel.setText("<html>spaceLocation: <br>" + twoDigits.format(this.spaceship.getSpaceLocation().getX()) + ", " + twoDigits.format(this.spaceship.getSpaceLocation().getY()) + "</html>");
            Point screenLocation = this.calculateScreenLocation(this.spaceship);
            this.screenLocationLabel.setText("<html>screenLocation: <br>  " + screenLocation.getX() + ", " + screenLocation.getY());
            this.angleToHomeLabel.setText("Angle to home: " + zeroDigits.format(Math.toDegrees(new LAVector(this.spaceship.getSpaceLocation(), this.focus).getAngle() - Math.PI)));
            this.directionToHomeLabel.repaint();
            this.directionToCometLabel.repaint();
            this.speedLabel.setText("Geschwindigkeit: " + twoDigits.format(this.spaceship.getImpuls().getLength()));
            this.windowLabel.setText("<html>windowXmin: " + twoDigits.format(this.winXmin) + "<br>windowWidth: " + twoDigits.format(this.windowWidth) + "<br>winYmin: " + twoDigits.format(this.winYmin) + "<br>windowHeight: " + twoDigits.format(this.windowHeight));
            if (!this.spacePressed) {
                this.testLabel.setText("<html>Kraft am Meteor: <br>" + twoDigits.format(this.comet.getGravity().getLength() * 10000.0));
            }
            this.testLabel2.setText("<html>Meteor Geschwindigkeit: <br>" + twoDigits.format(this.comet.getImpuls().getLength()) + "</html>");
        });
    }

    public void scale() {
        LAVector objectToFocus = new LAVector(this.spaceship.getSpaceLocation(), this.focus);
        this.distanceToFocus = objectToFocus.getLength();
        this.angleToFocus = objectToFocus.getAngle();
        this.elipseLine = Math.sqrt(Math.pow(Math.cos(this.angleToFocus) * (double)this.mainComponent.getWidth() * 0.4, 2.0) + Math.pow(Math.sin(this.angleToFocus) * (double)this.mainComponent.getHeight() * 0.4, 2.0));
        this.scaleFactor = this.elipseLine / this.distanceToFocus;
        if (this.scaleFactor < this.minScaleFactor) {
            this.scaleFactor = this.minScaleFactor;
        }
        if (this.scaleFactor > this.maxScaleFactor) {
            this.scaleFactor = this.maxScaleFactor;
        }
    }

    public void window() {
        this.windowWidth = (double)(this.mainComponent.getWidth() * 1) / this.scaleFactor;
        this.windowHeight = (double)(this.mainComponent.getHeight() * 1) / this.scaleFactor;
        this.winXmin = this.focus.getX() - this.windowWidth / 2.0;
        this.winYmin = this.focus.getY() - this.windowHeight / 2.0;
        this.winYMax += this.windowHeight;
        double startScrolling = this.elipseLine * 1.5;
        if (this.spaceship.getDistanceTo(this.focus) > startScrolling) {
            if (this.spaceship.getSpaceLocation().getX() < this.focus.getX()) {
                this.winXmin = this.spaceship.getSpaceLocation().getX() - this.windowWidth / 2.0 + Math.sqrt(Math.pow(startScrolling, 2.0) - Math.pow(Math.sin(this.angleToFocus) * startScrolling, 2.0));
            }
            if (this.spaceship.getSpaceLocation().getX() > this.focus.getX()) {
                this.winXmin = this.spaceship.getSpaceLocation().getX() - this.windowWidth / 2.0 - Math.sqrt(Math.pow(startScrolling, 2.0) - Math.pow(Math.sin(this.angleToFocus) * startScrolling, 2.0));
            }
            if (this.spaceship.getSpaceLocation().getY() < this.focus.getY()) {
                this.winYmin = this.spaceship.getSpaceLocation().getY() - this.windowHeight / 2.0 + Math.sqrt(Math.pow(startScrolling, 2.0) - Math.pow(Math.cos(this.angleToFocus) * startScrolling, 2.0));
            }
            if (this.spaceship.getSpaceLocation().getY() > this.focus.getY()) {
                this.winYmin = this.spaceship.getSpaceLocation().getY() - this.windowHeight / 2.0 - Math.sqrt(Math.pow(startScrolling, 2.0) - Math.pow(Math.cos(this.angleToFocus) * startScrolling, 2.0));
            }
        }
    }

    private Point calculateScreenLocation(Spaceobject spaceobject) {
        int xLocation = (int)((spaceobject.getSpaceLocation().getX() - this.winXmin) / this.windowWidth * (double)this.mainComponent.getWidth());
        int yLocation = (int)((spaceobject.getSpaceLocation().getY() - this.winYmin) / this.windowHeight * (double)this.mainComponent.getHeight());
        return new Point(xLocation, yLocation);
    }

    private void setUpKeyBindings() {
        int condition = 2;
        InputMap inputMap = this.getRootPane().getInputMap(condition);
        ActionMap actionMap = this.getRootPane().getActionMap();
        int leftKey = KeyStroke.getKeyStroke(37, 0).getKeyCode();
        inputMap.put(KeyStroke.getKeyStroke(leftKey, 0, false), "leftPressed");
        inputMap.put(KeyStroke.getKeyStroke(leftKey, 0, true), "leftReleased");
        actionMap.put("leftPressed", new KeyAction(37, true));
        actionMap.put("leftReleased", new KeyAction(37, false));
        int rightKey = KeyStroke.getKeyStroke(39, 0).getKeyCode();
        inputMap.put(KeyStroke.getKeyStroke(rightKey, 0, false), "rightPressed");
        inputMap.put(KeyStroke.getKeyStroke(rightKey, 0, true), "rightReleased");
        actionMap.put("rightPressed", new KeyAction(39, true));
        actionMap.put("rightReleased", new KeyAction(39, false));
        int upKey = KeyStroke.getKeyStroke(38, 0).getKeyCode();
        inputMap.put(KeyStroke.getKeyStroke(upKey, 0, false), "upPressed");
        inputMap.put(KeyStroke.getKeyStroke(upKey, 0, true), "upReleased");
        actionMap.put("upPressed", new KeyAction(38, true));
        actionMap.put("upReleased", new KeyAction(38, false));
        int downKey = KeyStroke.getKeyStroke(40, 0).getKeyCode();
        inputMap.put(KeyStroke.getKeyStroke(downKey, 0, false), "downPressed");
        inputMap.put(KeyStroke.getKeyStroke(downKey, 0, true), "downReleased");
        actionMap.put("downPressed", new KeyAction(40, true));
        actionMap.put("downReleased", new KeyAction(40, false));
        int spaceKey = KeyStroke.getKeyStroke(32, 0).getKeyCode();
        inputMap.put(KeyStroke.getKeyStroke(spaceKey, 0, false), "spacePressed");
        inputMap.put(KeyStroke.getKeyStroke(spaceKey, 0, true), "spaceReleased");
        actionMap.put("spacePressed", new KeyAction(32, true));
        actionMap.put("spaceReleased", new KeyAction(32, false));
        int leftShiftKey = KeyStroke.getKeyStroke(16, 0).getKeyCode();
        inputMap.put(KeyStroke.getKeyStroke(leftShiftKey, 0, false), "leftShiftPressed");
        inputMap.put(KeyStroke.getKeyStroke(leftShiftKey, 0, true), "leftShiftReleased");
        actionMap.put("leftShiftPressed", new KeyAction(16, true));
        actionMap.put("leftShiftReleased", new KeyAction(16, false));
        int mKey = KeyStroke.getKeyStroke(77, 0).getKeyCode();
        inputMap.put(KeyStroke.getKeyStroke(mKey, 0, false), "mPressed");
        inputMap.put(KeyStroke.getKeyStroke(mKey, 0, true), "mReleased");
        actionMap.put("mPressed", new KeyAction(77, true));
        actionMap.put("mReleased", new KeyAction(77, false));
        int yKey = KeyStroke.getKeyStroke(89, 0).getKeyCode();
        inputMap.put(KeyStroke.getKeyStroke(yKey, 0, false), "yPressed");
        inputMap.put(KeyStroke.getKeyStroke(yKey, 0, true), "yReleased");
        actionMap.put("yPressed", new KeyAction(89, true));
        actionMap.put("yReleased", new KeyAction(89, false));
    }

    private void reset() {
        this.spaceship.setSpaceLocation(0.0, 0.0);
        this.spaceship.setImpuls(new LAVector(0.0, 0.0));
        this.comet.setSpaceLocation(600.0, 0.0);
        this.comet.setImpuls(new LAVector(2.0, 90.0));
    }

    private void handleContinuousKeyEvents() {
        if (this.upKeyPressed) {
            this.spaceship.accelerate();
        }
        if (this.downKeyPressed) {
            this.spaceship.decelerate();
        }
        if (this.leftKeyPressed) {
            this.spaceship.setAngle(this.spaceship.getAngle() - 0.1);
        }
        if (this.rightKeyPressed) {
            this.spaceship.setAngle(this.spaceship.getAngle() + 0.1);
        }
        if (this.leftShiftPressed) {
            this.testLabel.setText("left Shift pressed continously");
        }
        if (this.mPressed) {
            this.testLabel.setText("mKeyPressed");
            System.out.println("mKeyPressed");
        }
        if (this.spacePressed) {
            this.comet.applyGravity(this.spaceship);
            this.testLabel.setText("<html>Gravity on comet: <br>" + twoDigits.format(this.comet.getGravity().getLength() * 10000.0));
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            DesktopStarter desktopStarter = new DesktopStarter();
            desktopStarter.setVisible(true);
            new Thread(() -> {
                while (true) {
                    desktopStarter.handleContinuousKeyEvents();
                    int i = 0;
                    while (i < desktopStarter.spaceobjectStack.size()) {
                        Spaceobject spaceobject = (Spaceobject)desktopStarter.spaceobjectStack.elementAt(i);
                        spaceobject.updateLocation();
                        ++i;
                    }
                    desktopStarter.comet.applyGravity(desktopStarter.planet);
                    desktopStarter.updateMonitorWindow();
                    desktopStarter.mainComponent.repaint();
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }).start();
        });
    }

    private class KeyAction
    extends AbstractAction {
        private int keyCode;
        private boolean pressed;

        public KeyAction(int keyCode, boolean pressed) {
            this.keyCode = keyCode;
            this.pressed = pressed;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.keyCode) {
                case 37: {
                    DesktopStarter.this.leftKeyPressed = this.pressed;
                    break;
                }
                case 39: {
                    DesktopStarter.this.rightKeyPressed = this.pressed;
                    break;
                }
                case 38: {
                    DesktopStarter.this.upKeyPressed = this.pressed;
                    DesktopStarter.this.spaceship.changeImage(0);
                    if (this.pressed) break;
                    DesktopStarter.this.spaceship.changeImage(1);
                    break;
                }
                case 40: {
                    DesktopStarter.this.downKeyPressed = this.pressed;
                    break;
                }
                case 32: {
                    DesktopStarter.this.spacePressed = this.pressed;
                    DesktopStarter.this.spaceship.showOutline(true);
                    DesktopStarter.this.spaceship.activateBeam(true);
                    if (this.pressed) break;
                    DesktopStarter.this.spaceship.showOutline(false);
                    DesktopStarter.this.spaceship.activateBeam(false);
                    break;
                }
                case 77: {
                    DesktopStarter.this.mPressed = this.pressed;
                    break;
                }
                case 89: {
                    DesktopStarter.this.reset();
                    DesktopStarter.this.yPressed = this.pressed;
                    if (!this.pressed) break;
                    DesktopStarter.this.testLabel.setText("Y Pressed");
                    System.out.println("Y Pressed");
                    break;
                }
                case 16: {
                    DesktopStarter.this.testLabel.setText("LShift released");
                    DesktopStarter.this.leftShiftPressed = this.pressed;
                    if (!this.pressed) break;
                    DesktopStarter.this.testLabel.setText("LShift pressed");
                    System.out.println("VK_Shift pressed");
                }
            }
        }
    }
}

