/*
 * Decompiled with CFR 0.152.
 */
import java.awt.geom.Point2D;

public class LAVector {
    private double length;
    private double angle;

    public LAVector() {
        this.length = 0.0;
        this.angle = 0.0;
    }

    public LAVector(double initialLength, double initialAngle) {
        this.length = initialLength;
        this.angle = initialAngle;
    }

    public LAVector(Point2D location) {
        this.length = Math.sqrt(Math.pow(location.getX(), 2.0) + Math.pow(location.getY(), 2.0));
        this.angle = Math.atan2(location.getY(), location.getX());
    }

    public LAVector(Point2D start, Point2D target) {
        this.length = Math.sqrt(Math.pow(target.getX() - start.getX(), 2.0) + Math.pow(target.getY() - start.getY(), 2.0));
        this.angle = Math.atan2(target.getY() - start.getY(), target.getX() - start.getX());
    }

    public void add(LAVector c) {
        double x = this.toPoint().getX() + c.toPoint().getX();
        double y = this.toPoint().getY() + c.toPoint().getY();
        this.length = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        this.angle = Math.atan2(y, x);
    }

    public double getAngle() {
        return this.angle;
    }

    public double getLength() {
        return this.length;
    }

    public Point2D toPoint() {
        double x = this.length * Math.cos(this.angle);
        double y = this.length * Math.sin(this.angle);
        return new Point2D.Double(x, y);
    }
}

