/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class Spaceobject {
    private LAVector impuls;
    private LAVector gravityDiv;
    private Point2D spaceLocation;
    private double angle;
    private double convenientScaleFactor;
    private double mass;
    private ImageIcon objectIcon;
    private BufferedImage objectImage;
    private Area objectArea;
    private Stack<BufferedImage> imageStack = new Stack();
    public Color outlineColor = Color.green;
    public Color beamColor = Color.green;
    public boolean rotates = true;
    public boolean showOutline = false;
    public boolean activateBeam = false;

    public Spaceobject() {
        this.objectIcon = new ImageIcon();
        this.spaceLocation = new Point2D.Double(0.0, 0.0);
        this.impuls = new LAVector(0.0, 0.0);
        this.angle = 0.0;
        this.convenientScaleFactor = 1.0;
        this.mass = 100.0;
    }

    public Spaceobject(Point2D initialLocation, double convenientScaleFactor) {
        this.objectImage = new BufferedImage(1, 1, 13);
        this.spaceLocation = initialLocation;
        this.impuls = new LAVector(0.0, 0.0);
        this.angle = 0.0;
        this.convenientScaleFactor = convenientScaleFactor;
        this.mass = 100.0;
        this.createObjectArea();
    }

    public Spaceobject(Point2D initialLocation, LAVector initialImpuls) {
        this.objectIcon = new ImageIcon();
        this.spaceLocation = initialLocation;
        this.impuls = initialImpuls;
        this.angle = 0.0;
        this.convenientScaleFactor = 1.0;
        this.mass = 100.0;
    }

    public void accelerate() {
        double acceleration = 0.1;
        LAVector accelerationVector = new LAVector(acceleration, this.angle);
        this.impuls.add(accelerationVector);
    }

    public void activateBeam(boolean b) {
        this.activateBeam = b;
    }

    public boolean activateBeam() {
        return this.activateBeam;
    }

    public void addImage(String imagePath) {
        try {
            this.objectImage = ImageIO.read(this.getClass().getResource(imagePath));
            this.createObjectArea();
            this.objectIcon = new ImageIcon(this.objectImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.imageStack.push(this.objectImage);
    }

    public void addImage(ImageIcon imageIcon) {
        this.objectIcon = imageIcon;
        this.imageStack.push(this.objectImage);
    }

    public void changeImage(int imageNumber) {
        if (imageNumber <= this.imageStack.size() - 1) {
            this.objectImage = (BufferedImage)this.imageStack.elementAt(imageNumber);
        }
    }

    public void createObjectArea() {
        this.objectArea = new Area();
        int y = 0;
        while (y < this.objectImage.getHeight()) {
            int x = 0;
            while (x < this.objectImage.getWidth()) {
                if ((this.objectImage.getRGB(x, y) & 0xFF000000) != 0) {
                    this.objectArea.add(new Area(new Rectangle(x, y, 1, 1)));
                }
                ++x;
            }
            ++y;
        }
    }

    public void applyGravity(Spaceobject spaceobject) {
        double gravConst = 1.0;
        double gravity = gravConst * this.getMass() * spaceobject.getMass() / Math.pow(this.getSpaceLocation().distance(spaceobject.getSpaceLocation()), 2.0);
        this.gravityDiv = new LAVector(spaceobject.getMass() * gravity / (this.getMass() + spaceobject.getMass()), this.getAngleTo(spaceobject.getSpaceLocation()));
        this.impuls.add(this.gravityDiv);
    }

    public void decelerate() {
        double oldSpeed = this.getImpuls().getLength();
        oldSpeed -= oldSpeed * 0.01;
        double newSpeed = oldSpeed;
        this.setImpuls(new LAVector(newSpeed, this.impuls.getAngle()));
    }

    public double getAngle() {
        return this.angle;
    }

    public double getAngleTo(Point2D point) {
        LAVector vector = new LAVector(this.getSpaceLocation(), point);
        return vector.getAngle();
    }

    public double getConvenientScaleFactor() {
        return this.convenientScaleFactor;
    }

    public double getDistanceTo(Point2D point) {
        LAVector vector = new LAVector(this.getSpaceLocation(), point);
        return vector.getLength();
    }

    public LAVector getGravity() {
        return this.gravityDiv;
    }

    public ImageIcon getIcon() {
        return this.objectIcon;
    }

    public BufferedImage getImage() {
        return this.objectImage;
    }

    public LAVector getImpuls() {
        return this.impuls;
    }

    public Area getObjectArea() {
        return this.objectArea;
    }

    public Point2D getSpaceLocation() {
        return this.spaceLocation;
    }

    public double getMass() {
        return this.mass;
    }

    public void scaleImage(double scaleX, double scaleY) {
        int newWidth = (int)((double)this.objectImage.getWidth() * scaleX);
        int newHeight = (int)((double)this.objectImage.getHeight() * scaleY);
        BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, this.objectImage.getType());
        Graphics2D g2d = scaledImage.createGraphics();
        AffineTransform transform = AffineTransform.getScaleInstance(scaleX, scaleY);
        g2d.drawRenderedImage(this.objectImage, transform);
        g2d.dispose();
        this.objectImage = scaledImage;
    }

    public void setAngle(double newAngle) {
        this.angle = newAngle;
        while (this.angle < 0.0) {
            this.angle += Math.PI * 2;
        }
        while (this.angle >= Math.PI * 2) {
            this.angle -= Math.PI * 2;
        }
    }

    public void setGravity(double d) {
        this.gravityDiv = new LAVector(d, 0.0);
    }

    public void setImpuls(LAVector c) {
        this.impuls = c;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public void setSpaceLocation(double x, double y) {
        this.spaceLocation = new Point2D.Double(x, y);
    }

    public void showOutline(boolean b) {
        this.showOutline = b;
    }

    public boolean showsOutline() {
        return this.showOutline;
    }

    public void size(int width, int height) {
        this.objectIcon = new ImageIcon(this.objectImage.getScaledInstance(width, height, 4));
    }

    public void updateLocation() {
        LAVector locationVector = new LAVector(this.spaceLocation);
        locationVector.add(this.impuls);
        this.spaceLocation.setLocation(locationVector.getLength() * Math.cos(locationVector.getAngle()), locationVector.getLength() * Math.sin(locationVector.getAngle()));
    }

    public double calculateOffsetToCenter(double zeroPoint, double distanceToFocus) {
        double arcustangensSmoothingFactor = 100.0;
        double arcustangensXTranslation = 5.0;
        double hyperbolicCoefficient = -zeroPoint / distanceToFocus + 1.0;
        double arcustangentialCoefficient = Math.atan(distanceToFocus / arcustangensSmoothingFactor - arcustangensXTranslation) / Math.PI + 0.5;
        return distanceToFocus - distanceToFocus * hyperbolicCoefficient * arcustangentialCoefficient;
    }
}

